define([
    'marionette',
    'text!modules/appointments/requested/request-messages-desc.html',
], function(Marionette, template) {
    'use strict';


    return Marionette.View.extend({
        tagName: 'p',
        className: 'request-messages-desc',
        template: template,
        modelEvents: {'change:status': 'render'},
        collectionEvents: {'sync': 'render'},
        // serialize model only
        serializeData: function() {
            var data = {};

            if (this.model) {
                data = this.model.toJSON();
            }

            return data;
        },
        templateContext: function() {
            var self = this;

            return {
                hasMessages: function() {
                    return self.collection.length > 0;
                },
                hasSentMaxMessages: function() {
                    var maxMessages = 2;
                    return self.collection.getVeteranMessageCount() >= maxMessages;
                },
            };
        },
    });
});
